function de = getDe(ssm, de)
% TO DO
%PLOT Plot a StateSpaceModel or a DynamicElement belonging to a StateSpaceModel
%
% Usage:
%   plot(ssm)
%   plot(ssm, de)
%
% If only ssm is given, creates 4 different figures:
%   Figure 1: plots all state trajectories
%   Figure 2: plots all control trajectories
%   Figure 3: plots all input trajectories
%   Figure 4: plots all auxiliary state trajectories
%
% If de is also given, creates a plot of the DynamicElement de.
% In this case this function is useful if de has no val field calculated,
% but a def field that depends on other elements in ssm, that do have a val
% field calculated

% David Katzin, Wageningen University
% david.katzin@wur.nl

    % reset definitions of states to their names
    stateNames = fieldnames(ssm.x);
    for k=1:length(stateNames)
        x.(stateNames{k}) = ssm.x.(stateNames{k});
        x.(stateNames{k}).def = ['x.' (stateNames{k})];
    end
    
    % load other SSM elements
    u = ssm.u; d = ssm.d; a = ssm.a; p = ssm.p;
    de = eval(de.def);
    
end

